USE [V5_Registry]
GO
	--Insert Survey Information
	INSERT INTO [dbo].[STD_SURVEY_TYPE]
           ([CODE],[NAME],[DESCRIPTION_TEXT],[CREATEDBY],[UPDATEDBY],[CREATED],[UPDATED])
     VALUES
           ('SWLS', 'Satisfaction With Life Scale', 'Satisfaction With Life Scale', 'Initial', 'Initial', GETDATE(), GETDATE());

	declare @type     int;
	SELECT @type=  (SELECT ID [STD_SURVEY_TYPE_ID]
	FROM STD_SURVEY_TYPE
	WHERE CODE = 'SWLS');

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, 'D', 'Date of assessment:', 1, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '1', 'In most ways my life is close to my ideal.', 2, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '2', 'The conditions of my life are excellent.', 3, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '3', 'I am satisfied with my life.', 4, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '4', 'So far I have gotten the important things I want in life.', 5, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)

	INSERT INTO [dbo].[STD_QUESTION]
           ([STD_SURVEY_TYPE_ID],[QUESTION_NUMBER],[QUESTION_TEXT],[SORT_ORDER],[CREATEDBY],[CREATED],[UPDATEDBY],[UPDATED],[INACTIVE_FLAG],[INACTIVE_DATE])
     VALUES
           (@type, '5', 'If I could live my life over, I would change almost nothing.', 6, 'InitialLoad', GETDATE(), 'InitialLoad', GETDATE(),0, NULL)


	declare @question     int, 
			@choice       int;       
	
	--Date Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'SWLS' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 1)
	--Date Choice
	SET @choice = ((SELECT MAX(STD_QUESTION_CHOICE_ID) from [dbo].[STD_QUESTION_CHOICE]) + 1)
	--If choice is null, meaning the choice table is empty, set it to 1
	IF @choice IS NULL SET @choice = 1
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, 'Date', 'Date', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 1 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'SWLS' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 2)
	--Question 1 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'strongly disagree', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'disagree', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'slightly disagree', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'neither agree nor disagree', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'slightly agree', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '6', 'agree', 6, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '7', 'strongly agree', 7, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())


	--Question 2 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'SWLS' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 3)
	--Question 2 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'strongly disagree', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'disagree', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'slightly disagree', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'neither agree nor disagree', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'slightly agree', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '6', 'agree', 6, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '7', 'strongly agree', 7, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())


	--Question 3 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'SWLS' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 4)
	--Question 3 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'strongly disagree', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'disagree', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'slightly disagree', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'neither agree nor disagree', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'slightly agree', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '6', 'agree', 6, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '7', 'strongly agree', 7, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 4 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'SWLS' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 5)
	--Question 4 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'strongly disagree', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'disagree', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'slightly disagree', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'neither agree nor disagree', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'slightly agree', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '6', 'agree', 6, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '7', 'strongly agree', 7, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

	--Question 5 Reference
	SELECT @question=  (SELECT q.ID  
	FROM STD_QUESTION q
		,STD_SURVEY_TYPE t
	WHERE CODE = 'SWLS' AND t.ID = q.STD_SURVEY_TYPE_ID AND q.SORT_ORDER = 6)
	--Question 5 Choices
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '1', 'strongly disagree', 1, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '2', 'disagree', 2, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '3', 'slightly disagree', 3, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '4', 'neither agree nor disagree', 4, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '5', 'slightly agree', 5, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '6', 'agree', 6, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())
	SET @choice = @choice + 1 
	INSERT INTO [dbo].[STD_QUESTION_CHOICE]
           ([STD_QUESTION_CHOICE_ID], [STD_QUESTION_ID], [CHOICE_NAME] ,[CHOICE_TEXT] ,[CHOICE_SORT_ORDER]
           ,[INACTIVE_FLAG] ,[INACTIVE_DATE] ,[CREATEDBY] ,[UPDATEDBY] ,[CREATED] ,[UPDATED])
     VALUES
           (@choice, @question, '7', 'strongly agree', 7, 0, NULL, 'InitialLoad', 'InitialLoad', GETDATE(), GETDATE())

GO